﻿//If the MCS namespace object is not defined, create it.
if (typeof MCS == "undefined")
{ MCS = {}; }
// Create Namespace container for functions in this library;
MCS.Appointment = {};
MCS.Appointment.Util = {};
MCS.Appointment.DisplayFields = {};

MCS.Appointment.FORM_TYPE_CREATE = 1;
MCS.Appointment.FORM_TYPE_UPDATE = 2;
MCS.Appointment.FORM_TYPE_READ_ONLY = 3;
MCS.Appointment.FORM_TYPE_DISABLED = 4;

MCS.Appointment.populateResources = function () {
    var attendeesObj = Xrm.Page.getAttribute("requiredattendees");
    var newAttendee = Xrm.Page.getAttribute("cvt_resourcegroup").getValue();
    if (newAttendee == null)
        return;
    var participants = new Array();
    var relatedEquipment = new Array();

    // query where group.relatedresoucegroupid == newAttendee.id
    var filter = "mcs_relatedResourceGroupId/Id eq guid'" + newAttendee[0].id + "'";
    CrmRestKit.ByQuery('mcs_groupresource', ['mcs_relatedResourceGroupId','mcs_RelatedResourceId','mcs_RelatedUserId'], filter, true).fail(
        function(err){
            alert("unable to retrieve group" + err);
            return;
        }).done(
        function(groups){
            //got all group resources, now need to get all equipment where equipment,relatedResource == group.relatedresource
            for (var i = 0; groups.d.results.length > i; i++){
                //do query instead of retreive bc we dont know id of equipment, just id of related resource which is also unique,
                //although ByQuery returns a list, there will always just be 1 result in this instance
                var id = groups.d.results[i].mcs_RelatedResourceId.Id;
                var filter = "";
                if (id != null){
                    filter = "mcs_relatedresource/Id eq guid'{" + id + "}'";
                    CrmRestKit.ByQuery('Equipment', ['EquipmentId', 'Name'], filter, false).fail(
                        function (err2) {
                            alert("unable to get equipment " + err2);
                            return;
                        }).done(
                        function (equipment) {
                            //Populate Equipment field
                            relatedEquipment[i] = new Object();
                            relatedEquipment[i].id = '{' + equipment.d.results[0].EquipmentId + '}';
                            relatedEquipment[i].name = equipment.d.results[0].Name;
                            relatedEquipment[i].entityType = "equipment";
                        });
                }
                else if (groups.d.results[i].mcs_RelatedUserId != null) {
                    CrmRestKit.Retrieve('SystemUser', groups.d.results[i].mcs_RelatedUserId.Id, ['SystemUserId', 'FullName'], false).fail(
                        function (err2) {
                            alert("unable to get User");
                            return;
                        }).done(
                        function (user) {
                            //we are still calling the object relatedEquipment even if its a user so we don't have to add another variable for no logical reason
                            relatedEquipment[i] = new Object();
                            relatedEquipment[i].id = user.d.SystemUserId;
                            relatedEquipment[i].name = user.d.FullName;
                            relatedEquipment[i].entityType = "systemuser";
                        });
                }
            }
            attendeesObj.setValue(relatedEquipment);
        });

};

MCS.Appointment.populateSite = function () {
    var newAttendee = Xrm.Page.getAttribute("cvt_resourcegroup").getValue();
    if (newAttendee == null)
        return;

    CrmRestKit.Retrieve('mcs_resourcegroup', newAttendee[0].id, ['mcs_relatedSiteId'], true).fail(
        function (err) {
            return;
        }).done(
        function (data) {
            var siteObj = new Array();
            siteObj[0] = new Object();
            siteObj[0].id = data.d.mcs_relatedSiteId.Id;
            siteObj[0].name = data.d.mcs_relatedSiteId.Name;
            siteObj[0].entityType = 'mcs_site';
            Xrm.Page.getAttribute("cvt_site").setValue(siteObj);
        });

};

MCS.Appointment.blockAddPatient = function () {
    var patientObj = Xrm.Page.getAttribute("optionalattendees");
    var patients = patientObj != null ? patientObj.getValue() : [];
    var newPatsAdded = MCS.Appointment.compareArrays(MCS.Patients, patients);
    if (newPatsAdded.length == 0) {
        //Determine if we want to re-build the cached patients list after removing a veteran - 
        //scenario: if you remove a veteran - click away - and then try to add a new one, should the one that got removed get added back or not?  
        //    MCS.Patients = Xrm.Page.getAttribute("optionalattendees").getValue();
        return;
    }
    else {
        alert("You can only add patients through the Patient Search.  Not adding: " + newPatsAdded);
        patientObj.setValue(MCS.Patients);
    }
};

MCS.Appointment.compareArrays = function (cachedPatients, newPatients) {
    var newPats = [];
    var newPatString = "";
    if (newPatients == null)
        return "";
    for (var i in newPatients) {
        var alreadyExists = false;
        var newPatIdObj = newPatients[i];
        if (newPatIdObj != null) {
            var newPatId = MCS.cvt_Common.TrimBookendBrackets(newPatIdObj.id.toLowerCase());
            for (var j in cachedPatients) {
                var cachedPatientObj = cachedPatients[j];
                var cachedPatientObjId = MCS.cvt_Common.TrimBookendBrackets(cachedPatientObj.id.toLowerCase());
                if (cachedPatientObj != null && newPatId == cachedPatientObjId) {
                    alreadyExists = true;
                    break;
                }
            }
        }
        if (!alreadyExists) {
            newPats.push(newPatIdObj.name);
        }
    }
    if (newPats.length > 0) {

        for (var pat in newPats) {
            newPatString += newPats[pat] + "; ";
        }
        newPatString = newPatString.substr(0, newPatString.length - 2);
    }
    return newPatString;
};